# -*- coding: iso-8859-1 -*-

#####################################################################
# Daniel Calderon S.
# CC3501
#####################################################################

# 02_Meteorito2.py
# ---------------
# Dibuja un meteorito utilizando transformaciones
# maneja orientacin desde las flechas del teclado
# ---------------

# Implementacin testeada con:
## Python 2.6
## PyOpenGL 3.0.1
## PyGame 1.9.1

#####################################################################

# importar librera grfica
from OpenGL.GL import *
from OpenGL.GLU import *

# importar librera para manejar eventos
import pygame
from pygame.locals import *

#####################################################################
# Funciones de inicializacin
#####################################################################

def init_pygame((w,h), title=""):
    pygame.init()
    pygame.display.set_mode((w,h), OPENGL|DOUBLEBUF)
    pygame.display.set_caption(title)
	
def init():
    glClearColor(0.0, 0.0, 0.0, 0.0)
    glClearDepth(1.0)
    glDisable(GL_DEPTH_TEST)
    glShadeModel(GL_SMOOTH)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST)
    glEnable (GL_BLEND)
    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
    glHint (GL_LINE_SMOOTH_HINT, GL_NICEST)

def reshape((width, height)):
    if height == 0:
        height = 1
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluOrtho2D(0.0, width, 0.0, height)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
	
def init_opengl((w,h)):
    init()
    reshape((w,h))

#####################################################################
# Funciones de dibujo
#####################################################################

def dibujarMeteorito(rx,ry,px,py,o,rgb):
    # rx,ry : tamao en ambas direcciones
    # px,py : posicin
    # o		: orientacin (ngulo en grados)

    glPushMatrix()
    
    glTranslatef(px,py,0.0)
    glScalef(rx,ry,0.0)
    glRotatef(o,0.0,0.0,1.0)
	
    glBegin(GL_POLYGON)			# setea mtodo de dibujo

    glColor4fv(rgb)	# asigna color al pincel
	
    glVertex2f(-143.0/150.0,-26.0/150.0)
    glVertex2f(-154.0/150.0,86.0/150.0)
    glVertex2f(-66.0/150.0,167.0/150.0)
    glVertex2f(142.0/150.0,110.0/150.0)
    glVertex2f(175.0/150.0,-44.0/150.0)
    glVertex2f(155.0/150.0,-108.0/150.0)
    glVertex2f(53.0/150.0,-108.0/150.0)
    glVertex2f(-39.0/150.0,-149.0/150.0)
    glVertex2f(-162.0/150.0,-121.0/150.0)
			
    glEnd()    # fin del mtodo de dibujo
    glPopMatrix()
	
#####################################################################

w=800 # ancho
h=600 # alto

# inicializando ...
init_pygame((w,h),"Titulo")
init_opengl((w,h))

# definiendo el meteorito
rx = 100
ry = 100
px = 300
py = 400
o = 30
rgb = [1.0,1.0,0.5,1.0]

run = True
while run:
    # 1: MANEJAMOS EVENTOS DE ENTRADA (TECLADO, MOUSE, ETC.)
    for event in pygame.event.get():
        if event.type == QUIT:
            run = False
        if event.type == KEYDOWN:
            if event.key == K_ESCAPE:
                run = False
            if event.key == K_LEFT:
                o += 30
            if event.key == K_RIGHT:
                o -= 30
				
    # 2: EJECUTAMOS LOGICA DE LA APLICACION
			
    # 3: DIBUJAMOS LOS ELEMENTOS
    glClear(GL_COLOR_BUFFER_BIT) # limpia la pantalla
    dibujarMeteorito(rx,ry,px,py,o,rgb)
	
    # vuelca el dibujo a la pantalla
    pygame.display.flip()

#####################################################################